/*
 * Decompiled with CFR 0.152.
 */
package au.com.fincleartech.ibroker;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.BadRequest;
import com.google.rpc.Code;
import com.google.rpc.Status;
import io.fincleartech.protobuf.ibroker.accounts.CreateFinancialSettlementDetailsRequest;
import io.fincleartech.protobuf.ibroker.accounts.CreateFinancialSettlementDetailsResponse;
import io.fincleartech.protobuf.ibroker.accounts.IBrokerAccountsServiceGrpc;
import io.fincleartech.protobuf.ibroker.settlement.DemandTransferConfirmation;
import io.fincleartech.protobuf.ibroker.subscribe.IBrokerAcknowledge;
import io.fincleartech.protobuf.ibroker.subscribe.IBrokerMessage;
import io.fincleartech.protobuf.ibroker.subscribe.IBrokerSubscribeServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import javax.net.ssl.SSLException;

public class Example {
    private StreamObserver<IBrokerAcknowledge> subscription = null;

    public static void main(String[] args) throws SSLException, InvalidProtocolBufferException {
        Example example = new Example();
        example.go(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void go(String[] args) throws SSLException, InvalidProtocolBufferException {
        SslContext sslContext = GrpcSslContexts.forClient().keyManager(new File("cert.pem"), new File("key.pem")).trustManager(new File("ca.pem")).build();
        ManagedChannel managedChannel = NettyChannelBuilder.forAddress((String)args[0], (int)Integer.parseInt(args[1])).sslContext(sslContext).build();
        IBrokerSubscribeServiceGrpc.IBrokerSubscribeServiceStub iBrokerStreaming = IBrokerSubscribeServiceGrpc.newStub((Channel)managedChannel);
        this.subscription = iBrokerStreaming.subscribe(new StreamObserver<IBrokerMessage>(){

            public void onNext(IBrokerMessage message) {
                switch (message.getMessageTypeCase()) {
                    case DEMAND_TRANSFER_CONFIRMATION: {
                        DemandTransferConfirmation demandTransferConfirmation = message.getDemandTransferConfirmation();
                        IBrokerAcknowledge ack = IBrokerAcknowledge.newBuilder().setMessageId(message.getMessageId()).build();
                        Example.this.subscription.onNext((Object)ack);
                        break;
                    }
                }
            }

            public void onError(Throwable t) {
            }

            public void onCompleted() {
            }
        });
        IBrokerAccountsServiceGrpc.IBrokerAccountsServiceBlockingStub iBroker = IBrokerAccountsServiceGrpc.newBlockingStub((Channel)managedChannel);
        CreateFinancialSettlementDetailsRequest.Builder requestBuilder = CreateFinancialSettlementDetailsRequest.newBuilder();
        requestBuilder.getRequestIdBuilder().setValue(UUID.randomUUID().toString());
        requestBuilder.getAccountNumberBuilder().setValue("10040");
        requestBuilder.getBsbNumberBuilder().setValue("013006");
        requestBuilder.getBankAccountNumberBuilder().setValue("940010037");
        requestBuilder.getBankAccountNameBuilder().setValue("EVE MAY WRIGHT");
        requestBuilder.getDirectDebitBuilder().setValue(false);
        requestBuilder.getDefaultPaymentBuilder().setValue(false);
        requestBuilder.getDefaultReceiptBuilder().setValue(false);
        requestBuilder.getCurrentBuilder().setValue(true);
        requestBuilder.getCmtFundBuilder().setValue("");
        requestBuilder.getPaymentGenMethodBuilder().setValue("A");
        requestBuilder.getReceiptGenMethodBuilder().setValue("D");
        requestBuilder.getSettlementTypeBuilder().setValue("T");
        requestBuilder.getAutoContraBuilder().setValue(true);
        requestBuilder.getSettlementGroupBuilder().setValue("GEN");
        requestBuilder.getHoldReasonBuilder().setValue("");
        try {
            CreateFinancialSettlementDetailsResponse response = iBroker.createFinancialSettlementDetails(requestBuilder.build());
            Status status = response.getStatus();
            Code statusCode = Code.forNumber((int)status.getCode());
            if (statusCode == Code.OK) {
                String accountNumber = response.getAccountNumber().getValue();
                String string = response.getFinancialSettlementDetailsId().getValue();
                return;
            }
            String errorMessage = status.getMessage();
            System.out.println(errorMessage);
            if (statusCode == Code.INVALID_ARGUMENT) {
                status.getDetailsList().stream().filter(any -> any.is(BadRequest.class)).map(Exceptions.wrap(any -> (BadRequest)any.unpack(BadRequest.class))).flatMap(badRequest -> badRequest.getFieldViolationsList().stream()).forEach(violation -> System.out.println(violation.getField() + ": " + violation.getDescription()));
                return;
            }
            if (statusCode != Code.ALREADY_EXISTS) return;
        }
        catch (StatusRuntimeException e) {
            io.grpc.Status status = e.getStatus();
            switch (status.getCode()) {
                case CANCELLED: {
                    return;
                }
                case UNKNOWN: {
                    return;
                }
                case PERMISSION_DENIED: {
                    return;
                }
                case UNIMPLEMENTED: {
                    return;
                }
                case UNAVAILABLE: {
                    return;
                }
            }
        }
    }

    private static class Exceptions {
        private Exceptions() {
        }

        public static <T, R, E extends Exception> Function<T, R> wrap(EFn<T, R, E> f) {
            return t -> {
                try {
                    return f.apply(t);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            };
        }

        public static interface EFn<T, R, E extends Exception> {
            public R apply(T var1) throws E;
        }
    }
}

